/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWValidationErrorTypeTableCellRenderer;
import filenet.vw.toolkit.design.message.images.VWImageLoader;
import filenet.vw.toolkit.design.message.resources.VWResource;
import javax.swing.ImageIcon;

class VWDesignerValidationItem {
    public static final int VALIDATION_LEVEL_ERROR = 1;
    public static final int VALIDATION_LEVEL_WARNING = 2;
    public static final int VALIDATION_TYPE_ANNOTATION = 12;
    public static final int VALIDATION_TYPE_FIELD = 4;
    public static final int VALIDATION_TYPE_INSTRUCTION = 7;
    public static final int VALIDATION_TYPE_MILESTONE = 8;
    public static final int VALIDATION_TYPE_PARAMETER = 3;
    public static final int VALIDATION_TYPE_PARTNERLINK = 10;
    public static final int VALIDATION_TYPE_ROUTE = 2;
    public static final int VALIDATION_TYPE_RULESET = 9;
    public static final int VALIDATION_TYPE_SCHEMA = 11;
    public static final int VALIDATION_TYPE_STEP = 1;
    public static final int VALIDATION_TYPE_WORKFLOW = 6;
    public static final int VALIDATION_TYPE_WORKFLOW_COLLECTION = 13;
    public static final int VALIDATION_SOURCE_WORKFLOW = 0;
    public static final int VALIDATION_SOURCE_WORKFLOW_COLLECTION = 1;
    private VWValidationError m_vwValidationError = null;
    private int m_nErrorType = -1;
    private String m_info = null;
    private int m_nLevel = 2;
    private String m_mapName = null;
    private String m_message = null;
    private String m_name = null;
    private int m_nStepId = -1;
    private int m_nSubStepId = -1;
    private int m_nSourceType = 0;
    private String m_sourceName = null;
    private static ImageIcon m_workflowIcon = null;
    private static ImageIcon m_workflowCollectionIcon = null;

    public VWDesignerValidationItem(VWValidationError vwValidationError, String sourceName, int nSourceType) {
        this.m_vwValidationError = vwValidationError;
        this.m_sourceName = sourceName;
        this.m_nSourceType = nSourceType;
    }

    public VWDesignerValidationItem(String name, int nType, String message, String info, String sourceName, int nSourceType) {
        this.m_name = name;
        this.m_nErrorType = nType;
        this.m_message = message;
        this.m_info = info;
        this.m_sourceName = sourceName;
        this.m_nSourceType = nSourceType;
    }

    public VWDesignerValidationItem(String name, int nType, String message, String info, String mapName, int nStepId, String sourceName, int nSourceType) {
        this(name, nType, message, info, sourceName, nSourceType);
        this.m_mapName = mapName;
        this.m_nStepId = nStepId;
    }

    public int getErrorType() {
        if (this.m_vwValidationError != null) {
            return this.m_vwValidationError.getErrorType();
        }
        return this.m_nErrorType;
    }

    public String getErrorTypeString() {
        switch (this.getErrorType()) {
            case 12: {
                return VWResource.s_textAnnotation;
            }
            case 4: {
                return VWResource.s_field;
            }
            case 7: {
                return VWResource.s_instruction;
            }
            case 8: {
                return VWResource.s_milestone;
            }
            case 3: {
                return VWResource.s_parameter;
            }
            case 10: {
                return VWResource.s_partnerLink;
            }
            case 2: {
                return VWResource.s_route;
            }
            case 9: {
                return VWResource.s_ruleSet;
            }
            case 11: {
                return VWResource.s_schema;
            }
            case 1: {
                return VWResource.s_step;
            }
            case 6: {
                return VWResource.s_workflow;
            }
            case 13: {
                return VWResource.s_workflowCollection;
            }
        }
        return null;
    }

    public ImageIcon getErrorTypeIcon(VWWorkflowDefinition wflDef) {
        if (wflDef != null) {
            return VWValidationErrorTypeTableCellRenderer.getErrorTypeIcon(this.getErrorType(), this.getName(), wflDef);
        }
        return null;
    }

    public String getInfo() {
        if (this.m_vwValidationError != null) {
            return this.m_vwValidationError.getInfo();
        }
        return this.m_info;
    }

    public int getLevel() {
        if (this.m_vwValidationError != null) {
            return this.m_vwValidationError.getLevel();
        }
        return this.m_nLevel;
    }

    public String getLevelString() {
        switch (this.getLevel()) {
            case 1: {
                return VWResource.s_error;
            }
            case 2: {
                return VWResource.s_warning;
            }
        }
        return null;
    }

    public String getMapName() {
        if (this.m_vwValidationError != null) {
            return this.m_vwValidationError.getMapName();
        }
        return this.m_mapName;
    }

    public String getMessage() {
        if (this.m_vwValidationError != null) {
            return this.m_vwValidationError.getMessage();
        }
        return this.m_message;
    }

    public String getName() {
        if (this.m_vwValidationError != null) {
            return this.m_vwValidationError.getName();
        }
        return this.m_name;
    }

    public int getStepId() {
        if (this.m_vwValidationError != null) {
            return this.m_vwValidationError.getStepId();
        }
        return this.m_nStepId;
    }

    public int getSubStepId() {
        if (this.m_vwValidationError != null) {
            return this.m_vwValidationError.getSubStepId();
        }
        return this.m_nSubStepId;
    }

    public ImageIcon getSourceIcon() {
        try {
            switch (this.m_nSourceType) {
                case 0: {
                    if (m_workflowIcon == null) {
                        m_workflowIcon = VWImageLoader.createImageIcon("workflow16.gif");
                    }
                    return m_workflowIcon;
                }
                case 1: {
                    if (m_workflowCollectionIcon == null) {
                        m_workflowCollectionIcon = VWImageLoader.createImageIcon("workflowCollection16.gif");
                    }
                    return m_workflowCollectionIcon;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public String getSourceName() {
        try {
            if (this.m_sourceName != null && this.m_sourceName.trim().length() > 0) {
                return this.m_sourceName;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return VWResource.s_blankName;
    }
}

